<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startPush('head'); ?>
        <style>
            /* Responsive table -> cards fallback */
            .table-responsive {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }

            .data-table {
                width: 100%;
                border-collapse: collapse;
            }

            .data-table th,
            .data-table td {
                padding: 0.65rem;
                text-align: left;
                border-bottom: 1px solid rgba(15, 23, 42, 0.04);
            }

            .data-table th {
                font-weight: 600;
                font-size: 0.875rem;
                color: rgba(2, 6, 23, 0.7);
            }

            /* mobile: hide table, show cards */
            .sensor-cards {
                display: none;
            }

            @media (max-width: 768px) {
                .table-responsive {
                    display: none;
                }

                .sensor-cards {
                    display: block;
                }

                .sensor-cards .card {
                    border: 1px solid rgba(15, 23, 42, 0.04);
                    padding: 0.75rem;
                    border-radius: 10px;
                    margin-bottom: 0.75rem;
                    background: var(--card, #fff);
                }

                .sensors-header {
                    flex-direction: column;
                    align-items: stretch;
                    gap: 0.5rem;
                }

                .sensors-header .actions {
                    display: flex;
                    gap: 0.5rem;
                    flex-wrap: wrap;
                    width: 100%;
                }

                .sensor-meta {
                    color: rgba(71, 85, 105, 0.9);
                    font-size: 0.9rem;
                    margin-top: 0.35rem;
                }

                .card-actions {
                    display: flex;
                    gap: 0.5rem;
                    justify-content: flex-end;
                    margin-top: 0.5rem;
                }
            }

            /* desktop: keep cards hidden */
            @media (min-width: 769px) {
                .sensor-cards {
                    display: none;
                }
            }

            .status-indicator {
                display: inline-flex;
                align-items: center;
                gap: 0.5rem;
                padding: 0.25rem 0.55rem;
                border-radius: 999px;
                font-weight: 600;
                font-size: 0.85rem;
            }

            .status-indicator .pulse {
                width: 8px;
                height: 8px;
                border-radius: 999px;
                display: inline-block;
                background: #94a3b8;
            }

            .status-indicator.active .pulse {
                background: #10b981;
            }

            .status-indicator.offline .pulse {
                background: #f97316;
            }

            .status-indicator.maintenance .pulse {
                background: #f59e0b;
            }
        </style>
    <?php $__env->stopPush(); ?>

    <header class="dashboard-header"
        style="display: flex; flex-direction: column; align-items: center; justify-content: center; text-align: center;">
        <span class="text-xs uppercase tracking-wide text-white/80 flex items-center gap-2">
            <i class="fa-solid fa-microchip"></i>
            Sensors Management
        </span>
        <h1 style="font-size: 1.25rem; margin-top: 0.5rem;">Manage Your Sensors</h1>
    </header>

    <div class="content-container">
        <!-- Flash Messages -->
        <?php if($errors->any()): ?>
            <div class="alert alert-danger mb-4">
                <div class="flex items-start gap-3">
                    <i class="fa-solid fa-circle-exclamation text-lg"></i>
                    <div>
                        <strong>Validation Errors</strong>
                        <ul class="mt-2 ml-4 list-disc">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="text-sm"><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="alert alert-success mb-4">
                <i class="fa-solid fa-check-circle"></i>
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <!-- Header Actions -->
        <div class="sensors-header mb-6 flex items-center justify-between">
            <div class="actions flex gap-3 flex-wrap">
                <a href="<?php echo e(route('sensors.create')); ?>" class="btn btn-primary">
                    <i class="fa-solid fa-plus"></i>
                    Create Sensor
                </a>
                <a href="<?php echo e(route('sensor-types.create')); ?>" class="btn btn-secondary">
                    <i class="fa-solid fa-layer-group"></i>
                    Create Sensor Type
                </a>
                <a href="<?php echo e(route('sensors.export')); ?>" class="btn btn-secondary">
                    <i class="fa-solid fa-download"></i>
                    Export CSV
                </a>
            </div>
        </div>

        <!-- Sensors Table (desktop) + Cards (mobile) -->
        <div class="table-card">
            <?php if($sensors->count() > 0): ?>
                <div class="table-responsive">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th width="5%"><input type="checkbox" id="selectAll" class="form-check-input"></th>
                                <th>Sensor Code</th>
                                <th>Name</th>
                                <th>Type</th>
                                <th>Location</th>
                                <th>Status</th>
                                <th>Created</th>
                                <th width="10%">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $sensors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sensor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $statusClass =
                                        $sensor->status === 'active'
                                            ? 'active'
                                            : ($sensor->status === 'inactive'
                                                ? 'offline'
                                                : 'maintenance');
                                ?>
                                <tr class="hover:bg-blue-50 transition-colors">
                                    <td><input type="checkbox" class="form-check-input sensor-checkbox"
                                            value="<?php echo e($sensor->id); ?>"></td>
                                    <td class="font-mono text-sm font-semibold"><?php echo e($sensor->sensor_code); ?></td>
                                    <td class="font-semibold"><?php echo e($sensor->name); ?></td>
                                    <td class="text-muted"><span
                                            class="badge badge-info"><?php echo e($sensor->sensorType->name); ?>

                                            (<?php echo e($sensor->sensorType->unit); ?>)
                                        </span></td>
                                    <td class="text-muted"><i class="fa-solid fa-map-pin text-xs mr-1"></i>
                                        <?php echo e($sensor->location); ?></td>
                                    <td><span class="status-indicator <?php echo e($statusClass); ?>"><span
                                                class="pulse"></span><?php echo e(ucfirst($sensor->status)); ?></span></td>
                                    <td class="text-sm text-muted"><?php echo e($sensor->created_at?->format('M d, Y') ?? '-'); ?>

                                    </td>
                                    <td>
                                        <div class="flex gap-2 justify-end">
                                            <a href="<?php echo e(route('sensors.show', $sensor)); ?>" class="btn-icon-sm"
                                                title="View"><i class="fa-solid fa-eye"></i></a>
                                            <a href="<?php echo e(route('sensors.edit', $sensor)); ?>" class="btn-icon-sm"
                                                title="Edit"><i class="fa-solid fa-pen-to-square"></i></a>
                                            <form action="<?php echo e(route('sensors.destroy', $sensor)); ?>" method="POST"
                                                class="inline" onsubmit="return confirm('Are you sure?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit"
                                                    class="btn-icon-sm text-red-600 hover:text-red-700"
                                                    title="Delete"><i class="fa-solid fa-trash"></i></button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Mobile: stacked cards -->
                <div class="sensor-cards" aria-hidden="true">
                    <?php $__currentLoopData = $sensors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sensor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $statusClass =
                                $sensor->status === 'active'
                                    ? 'active'
                                    : ($sensor->status === 'inactive'
                                        ? 'offline'
                                        : 'maintenance');
                        ?>
                        <div class="card">
                            <div
                                style="display:flex; justify-content:space-between; gap:0.75rem; align-items:flex-start;">
                                <div style="min-width:0;">
                                    <div class="font-mono text-sm font-semibold"><?php echo e($sensor->sensor_code); ?></div>
                                    <div class="font-semibold"><?php echo e($sensor->name); ?></div>
                                    <div class="sensor-meta"><span
                                            class="badge badge-info"><?php echo e($sensor->sensorType->name); ?>

                                            (<?php echo e($sensor->sensorType->unit); ?>)
                                        </span></div>
                                    <div class="sensor-meta"><i
                                            class="fa-solid fa-map-pin text-xs mr-1"></i><?php echo e($sensor->location); ?></div>
                                </div>
                                <div style="text-align:right; min-width:0;">
                                    <div><span class="status-indicator <?php echo e($statusClass); ?>"><span
                                                class="pulse"></span> <?php echo e(ucfirst($sensor->status)); ?></span></div>
                                    <div class="text-sm text-muted" style="margin-top:0.35rem;">
                                        <?php echo e($sensor->created_at?->format('M d, Y') ?? '-'); ?></div>
                                    <div class="card-actions">
                                        <a href="<?php echo e(route('sensors.show', $sensor)); ?>" class="btn-icon-sm"
                                            title="View"><i class="fa-solid fa-eye"></i></a>
                                        <a href="<?php echo e(route('sensors.edit', $sensor)); ?>" class="btn-icon-sm"
                                            title="Edit"><i class="fa-solid fa-pen-to-square"></i></a>
                                        <form action="<?php echo e(route('sensors.destroy', $sensor)); ?>" method="POST"
                                            class="inline" onsubmit="return confirm('Are you sure?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn-icon-sm text-red-600 hover:text-red-700"
                                                title="Delete"><i class="fa-solid fa-trash"></i></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fa-solid fa-microchip text-4xl opacity-30"></i>
                    <h3>No Sensors Yet</h3>
                    <p>Start by creating your first sensor.</p>
                    <a href="<?php echo e(route('sensors.create')); ?>" class="btn btn-primary mt-4">
                        <i class="fa-solid fa-plus"></i>
                        Create Sensor
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const selectAllCheckbox = document.getElementById('selectAll');
                const sensorCheckboxes = document.querySelectorAll('.sensor-checkbox');
                const bulkActions = document.getElementById('bulkActions');
                const selectedIds = document.getElementById('selectedIds');

                // Guard clause
                if (!selectAllCheckbox || sensorCheckboxes.length === 0) {
                    return;
                }

                function updateBulkActions() {
                    const checked = Array.from(sensorCheckboxes).filter(cb => cb.checked);
                    if (checked.length > 0) {
                        bulkActions.classList.remove('hidden');
                        selectedIds.innerHTML = checked.map(cb =>
                            `<input type="hidden" name="ids[]" value="${cb.value}">`
                        ).join('');
                    } else {
                        bulkActions.classList.add('hidden');
                    }
                }

                if (selectAllCheckbox) {
                    selectAllCheckbox.addEventListener('change', () => {
                        sensorCheckboxes.forEach(cb => cb.checked = selectAllCheckbox.checked);
                        updateBulkActions();
                    });
                }

                sensorCheckboxes.forEach(cb => {
                    cb.addEventListener('change', () => {
                        if (selectAllCheckbox) {
                            selectAllCheckbox.checked = Array.from(sensorCheckboxes).every(c => c
                                .checked);
                        }
                        updateBulkActions();
                    });
                });
            });
        </script>
    <?php $__env->stopPush(); ?>

    <footer class="ottoman-footer">
        <p>&copy; <span id="footerYear"><?php echo e(date('Y')); ?></span> Thermocouple Monitoring. All rights reserved.</p>
    </footer>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\proyek-oping\web-monitoring-laravel\tujukuda\iot2-laravel-lokal-main\resources\views/sensors/index.blade.php ENDPATH**/ ?>